<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/eral.php';
$settingsCheck = $DB->prepare("select * from settings where id=?");
$settingsCheck->execute(array('1'));
$settings = $settingsCheck->fetch(PDO::FETCH_ASSOC);
function id($text) {
    $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
    $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
    $text = strtolower(str_replace($find, $replace, $text));
    $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
    $text = trim(preg_replace('/\s+/', ' ', $text));
    $text = str_replace(' ', '', $text);
    return $text;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$translations['sitetitle']?></title>
    <meta name="description" content="<?=$settings['siteDesc']?>">
    <meta name="keywords" content="<?=$settings['siteKeyword']?>">
    <!-- FontAwesome-cdn include -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <!-- Google fonts include -->
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@400;500;600;700;800&family=Lato&display=swap"
        rel="stylesheet">
    <!-- Bootstrap-css include -->
    <link rel="stylesheet" href="./assets/css/bootstrap.min.css">
    <!-- Animate-css include -->
    <link rel="stylesheet" href="./assets/css/animate.min.css">
    <!-- Main-StyleSheet include -->
    <link rel="stylesheet" href="./assets/css/style.css?v=1.1">
    <link rel="stylesheet" href="./assets/css/intlTelInput.css">
    <link rel="stylesheet" type="text/css"
        href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/forms/select/select2.min.css">
    <link rel="stylesheet" type="text/css"
        href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/forms/select/select2.css">
    <link rel="stylesheet" type="text/css"
        href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css">
    <link rel="stylesheet" type="text/css"
        href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/plugins/forms/pickers/form-flat-pickr.css">
    <link rel="stylesheet" type="text/css"
        href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/css/calendars/fullcalendar.min.css">
    <link rel="stylesheet" type="text/css"
        href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/pages/app-calendar.css">
    <link rel="stylesheet" type="text/css"
        href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/css/plugins/forms/form-validation.css">
</head>
<script src="https://unpkg.com/feather-icons"></script>
<style>
.iti__flag {
    background-image: url("assets/images/flags/flags.png");
}
@media (-webkit-min-device-pixel-ratio: 2),
(min-resolution: 192dpi) {
    .iti__flag {
        background-image: url("assets/images/flags/flags@2x.png");
    }
}
.select2-container .select2-selection--single {
    height: 50px;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 45px;
}
.custom-options-checkable .custom-option-item {
    width: 100%;
    cursor: pointer;
    border-radius: 0.42rem;
    color: #82868b;
    background-color: rgba(130, 134, 139, 0.06);
    border: 1px solid #ebe9f1;
}
.custom-options-checkable .custom-option-item .custom-option-item-title {
    color: #82868b;
}
.custom-option-item-check {
    position: absolute;
    clip: rect(0, 0, 0, 0);
}
.custom-option-item-check:checked+.custom-option-item {
    color: #ff950e;
    background-color: linear-gradient(to right, #ffaf15, #fe6300);
    border-color: #ff950e;
}
.custom-option-item-check:checked+.custom-option-item .custom-option-item-title {
    color: #ff950e;
}
.custom-option-item-check-provider {
    position: absolute;
    clip: rect(0, 0, 0, 0);
}
.custom-option-item-check-provider:checked+.custom-option-item {
    color: #ff950e;
    background-color: linear-gradient(to right, #ffaf15, #fe6300);
    border-color: #ff950e;
}
.custom-option-item-check-provider:checked+.custom-option-item .custom-option-item-title {
    color: #ff950e;
}
.flatpickr-calendar .flatpickr-day.selected, .flatpickr-calendar .flatpickr-day.selected:hover{
    background: #ff950e;
    color: #fff;
    border-color: #ff950e;
}
.flatpickr-calendar .flatpickr-day.today {
    border-color: #ff950e;
}
.invalid{
    border-color: red;
}
.titleColor{
    background: -webkit-linear-gradient(top right, #ffaf15, #fe6300);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}
</style>
<body>
    <div class="wrapper position-relative overflow-hidden">
        <div class="container-md-fluid p-3 p-lg-0 me-5">
            <div class="row">
                <div class="col-xl-4">
                    <div class="form_logo position-absolute">
                        <a href="#">
                        <img src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/images/logo/<?=$settings['siteLogo']?>" alt="">
                        </a>
                    </div>
                    <div class="steps_area step_area_fixed d-none d-xl-block">
                        <div class="image_holder">
                            <img class="overflow-hidden" src="assets/images/background/bg_0.png" alt="image-not-found">
                        </div>
                        <div class="step_items position-absolute">
                            <div class="step d-block text-center bg-white position-relative current active">1</div>
                            <div class="step d-block text-center bg-white position-relative">2
                            </div>
                            <div class="step d-block text-center bg-white position-relative">3
                            </div>
                            <div class="step d-block text-center bg-white position-relative last">4
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-7 ps-5 pt-5">
                    <form class="multisteps_form" id="wizard" method="POST" action="success.php">
                        <!-- ------------------ Step-1 ------------------- -->
                        <div class="multisteps_form_panel" style="display: block;">
                        <?php if($settings['langSystem']=='1'){ ?>
                        <select style="width: 150px;margin-bottom:20px;" class="form-control" name="lang" id="lang">
                        <?php $langs = $DB->query("SELECT * from languages order by id")->fetchAll(PDO::FETCH_ASSOC); 
                            foreach ($langs as $langsCek) {
                                ?>
                            <option <?php if($language==$langsCek['code']){echo 'selected';} ?> value="<?=$langsCek['code']?>"><?=$langsCek['name']?></option>
                            <?php }?>
                            
                        </select>
                        <?php }?>
                            <div class="step_content d-flex justify-content-between pt-5 pb-2">
                                <h4><?=$translations['sitetitle']?></h4>
                                <span class="text-end text-uppercase">1. <?=$translations['step']?> | 1/4</span>
                            </div>
                            <div class="step_progress_bar">
                                <div class="progress rounded-pill">
                                    <div class="progress-bar" style="width:25%"></div>
                                </div>
                            </div>
                            <style>
                            .musteri {
                                padding: 10px;
                            }
                            .musteriB {
                                border-radius: 0.525rem;
                            }
                            </style>
                            <div class="form_content">
                                <div class="question_title py-5">
                                    <h1 class="text-capitalize"><?=$translations['info']?></h1>
                                </div>
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-1 form_items">
                                    <div class="col">
                                        <div class="input-group input-group-merge musteri">
                                            <span class="input-group-text musteriB"><i data-feather="user"></i></span>
                                            <input type="text" id="musteriAd" class="form-control musteri musteriB"
                                                name="musteriAd" placeholder="<?=$translations['namesurname']?>" />
                                        </div>
                                    </div>
                                    <?php if($settings['emailSystem']=='1'){ ?>
                                    <div class="col">
                                        <div class="input-group input-group-merge musteri">
                                            <span class="input-group-text musteriB"><i data-feather="mail"></i></span>
                                            <input type="text" id="musteriMail" class="form-control musteri musteriB"
                                                name="musteriMail" placeholder="Mail Adresi" />
                                        </div>
                                    </div>
                                    <?php } ?>
                                    <div class="col">
                                        <div class="input-group input-group-merge musteri">
                                            <input type="text" id="musteriTelefon" class="form-control musteri musteriB"
                                                name="musteriTelefon"  placeholder="5459548706" autocomplete="off" maxlength="10" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form_btn pt-5 d-flex justify-content-between">
                                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn"
                                    onclick="nextPrev(-1)" style="display: none;"><span><i
                                            class="fas fa-arrow-left"></i></span> <?=$translations['back']?></button>
                                <button type="button" class="next_btn text-uppercase text-white" id="nextBtn"
                                    onclick="nextPrev(1)"><?=$translations['continue']?> <span><i
                                            class="fas fa-arrow-right"></i></span></button>
                            </div>
                        </div>
                        <!-- ------------------ Step-2 ------------------- -->
                        <div class="multisteps_form_panel">
                            <div class="step_content d-flex justify-content-between pt-5 pb-2">
                                <h4><?=$translations['sitetitle']?></h4>
                                <span class="text-end text-uppercase">2. <?=$translations['step']?> | 2/4</span>
                            </div>
                            <div class="step_progress_bar">
                                <div class="progress rounded-pill">
                                    <div class="progress-bar" style="width:50%"></div>
                                </div>
                            </div>
                            <div class="form_content">
                                <div class="question_title py-5">
                                    <h1 class="text-capitalize"><?=$translations['chooseservice']?></h1>
                                </div>
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                                    <div class="col-12">
                                        <div class="mb-1">
                                            <select class="select2 select-label form-select w-100" id="service"
                                                name="service">
                                                <option selected="" disabled="" value=""><?=$translations['select']?></option>
                                                <?php $services = $DB->query("select * from services order by id ASC")->fetchAll(PDO::FETCH_ASSOC); 
                                            foreach ($services as $service) {
                                                ?>
                                                <option id="service<?=$service['id']?>"
                                                    data-label="<?=id($service['serviceName'])?>"
                                                    value="<?=$service['id']?>">
                                                    <?=$service['serviceName']?> | <?=$service['price']?>₺
                                                </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="mb-1">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div id="providerList" class="row custom-options-checkable g-1">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <script
                                        src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/jquery-3.5.1.min.js">
                                    </script>
                                    <script type="text/javascript">
                                    $(document).ready(function() {
                                        $("#service").change(function() {
                                            var serviceID = $(this).val();
                                            $.ajax({
                                                type: "POST",
                                                url: "admin/system/ajax/ProviderAjaxMusteri.php",
                                                data: {
                                                    "serviceID": serviceID
                                                },
                                                success: function(e) {
                                                    $("#providerList").html(e);
                                                    $("#timeSelect").html("");
                                                }
                                            });
                                        })
                                    });
                                    </script>
                                    <script type="text/javascript">
                                    $(document).ready(function() {
                                        $("#providerList").change(function() {
                                            var date = $('#start-date').val();
                                            var providerID = $('#providerID').val();
                                            var hizmetID = $('#service').val();
                                            $.ajax({
                                                type: "POST",
                                                url: "admin/system/ajax/AvailableTimeAjax.php",
                                                data: {
                                                    "date": date,
                                                    "providerID": providerID,
                                                    "hizmet": hizmetID
                                                },
                                                success: function(e) {
                                                    $("#timeSelect").html(e);
                                                }
                                            });
                                        })
                                    });
                                    </script>
                                </div>
                            </div>
                            <div class="form_btn pt-5 d-flex justify-content-between">
                                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn"
                                    onclick="nextPrev(-1)"><span><i class="fas fa-arrow-left"></i></span> <?=$translations['back']?></button>
                                <button type="button" class="next_btn text-uppercase text-white" id="nextBtn"
                                    onclick="nextPrev(1)"><?=$translations['continue']?> <span><i
                                            class="fas fa-arrow-right"></i></span></button>
                            </div>
                        </div>
                        <!-- ------------------ Step-3 ------------------- -->
                        <div class="multisteps_form_panel">
                            <div class="step_content d-flex justify-content-between pt-5 pb-2">
                                <h4><?=$translations['sitetitle']?></h4>
                                <span class="text-end text-uppercase">3. <?=$translations['step']?> | 3/4</span>
                            </div>
                            <div class="step_progress_bar">
                                <div class="progress rounded-pill">
                                    <div class="progress-bar" style="width:75%"></div>
                                </div>
                            </div>
                            <div class="form_content">
                                <div class="question_title py-5">
                                    <h1 class="text-capitalize"><?=$translations['selectdate']?></h1>
                                </div>
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                                    <div class="col-12">
                                        <div class="mb-1 position-relative">
                                            <input type="text" class="form-control" id="start-date" name="start-date"
                                                placeholder="<?=$translations['appointmentdate']?>" />
                                        </div>
                                    </div>
                                    <div style="margin-top:15px"></div>
                                    <div class="col-12">
                                        <div class="mb-1">
                                            <div class="row custom-options-checkable g-1" id="timeSelect">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <script type="text/javascript">
                            $(document).ready(function() {
                                $("#start-date").change(function() {
                                    var date = $(this).val();
                                    var providerID = $('#providerID').val();
                                    var hizmetID = $('#service').val();
                                    $.ajax({
                                        type: "POST",
                                        url: "admin/system/ajax/AvailableTimeAjax.php",
                                        data: {
                                            "date": date,
                                            "providerID": providerID,
                                            "hizmet": hizmetID
                                        },
                                        success: function(e) {
                                            $("#timeSelect").html(e);
                                        }
                                    });
                                })
                            });
                            </script>
                           <input type="hidden" id="providerAdSoyad" value="">
                            <input type="hidden" id="providerID" value="">
                            <div class="form_btn pt-5 d-flex justify-content-between">
                                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn"
                                    onclick="nextPrev(-1)"><span><i class="fas fa-arrow-left"></i></span> <?=$translations['back']?></button>
                                <button type="button" class="next_btn text-uppercase text-white" id="nextBtn"
                                    onclick="nextPrev(1)"><?=$translations['continue']?><span><i
                                            class="fas fa-arrow-right"></i></span></button>
                            </div>
                        </div>
                        <!-- ------------------ Step-4 ------------------- -->
                        <div class="multisteps_form_panel">
                            <div class="step_content d-flex justify-content-between pt-5 pb-2">
                                <h4><?=$translations['sitetitle']?></h4>
                                <span class="text-end text-uppercase">4. <?=$translations['step']?> | 4/4</span>
                            </div>
                            <div class="step_progress_bar">
                                <div class="progress rounded-pill">
                                    <div class="progress-bar" style="width: 100%"></div>
                                </div>
                            </div>
                            <div class="form_content">
                                <div class="question_title py-5">
                                    <h1 class="text-capitalize"><?=$translations['summary']?></h1>
                                </div>
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                                <div class="col">
                                <h3 class="titleColor"><?=$translations['perfonelinfo']?></h3><br>
                                <h5 id="OzetAdSoyad"></h5>
                                <h5 id="OzetTelefon"></h5>
                                </div>
                                <div class="col">
                                <h3 class="titleColor"><?=$translations['serviceinfo']?></h3><br>
                                <h5 id="OzetHizmetAd"></h5>
                                <h5 id="OzetCalisanAd"></h5>
                                </div>
                                <div class="col">
                                <h3 class="titleColor"><?=$translations['appointmentinfo']?></h3><br>
                                <h5 id="OzetTarih"></h5>
                                <h5 id="OzetSaat"></h5>
                                </div>
                                </div>
                                <?php if($settings['paytrSystem']=='1' || $settings['eftSystem']=='1' || $settings['salonCreditCardSystem']=='1'){ ?>
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                                    <div class="col-12">
                                    <div class="mb-1">
                                        <h3 style="margin-top: 30px;" class="titleColor"><?=$translations['paymentmethod']?></h3>
                                        <select class="form-select w-100" id="odemeYontemi" name="odemeYontemi">
                                            <option selected="" disabled="" value=""><?=$translations['paymentselect']?></option> 
                                            <option selected="" value="Nakit"><?=$translations['cash']?></option>
                                            <?php if($settings['salonCreditCardSystem']=='1'){ ?>
                                            <option value="SalonKrediKarti"><?=$translations['saloncreditcard']?></option>
                                            <?php }?>
                                            <?php if($settings['paytrSystem']=='1'){ ?>
                                            <option value="Kredi"><?=$translations['nowcreditcard']?></option>
                                            <?php }?>
                                            <?php if($settings['eftSystem']=='1'){ ?>
                                            <option value="Havale"><?=$translations['transfer']?></option>
                                            <?php }?>
                                        </select>
                                    </div>
                                    </div>
                                </div> 
                                <?php }?>
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 form_items">
                                    <div class="col-12">
                                    <div class="mb-1">
                                        <h3 style="margin-top: 30px;" class="titleColor"><?=$translations['note']?></h3>
                                        <input class="form-control w-100" type="text" name="note">
                                    </div>
                                    </div>
                                </div> 

                            </div>
                            <input type="hidden" value="0" name="randevuDuzenle" id="randevuEkleDurum">
                            <input type="hidden" value="1" name="randevuEkle" id="randevuEkleDurum">
                            <div class="form_btn pt-5 d-flex justify-content-between">
                                <button type="button" class="prev_btn text-uppercase bg-white" id="prevBtn"
                                    onclick="nextPrev(-1)"><span><i class="fas fa-arrow-left"></i></span> <?=$translations['back']?></button>
                                <button id="randevuEkle" type="button" class="next_btn text-uppercase text-white" id="nextBtn"
                                    ><?=$translations['create']?><span><i
                                            class="fas fa-arrow-right"></i></span></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- jQuery-js include -->
    <script src="./assets/js/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap-js include -->
    <script src="./assets/js/bootstrap.min.js"></script>
    <!-- jQuery-validate-js include -->
    <script src="./assets/js/jquery.validate.min.js"></script>
    <!-- Custom-js include -->
    <script src="./assets/js/script.js"></script>
    
    <script src="./assets/js/intlTelInput.js"></script>
    <script
        src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/forms/select/select2.full.min.js">
    </script>
    <!--<script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/forms/form-wizard.js">
    </script>-->
    <script
        src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js">
    </script>
    <script
        src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/vendors/js/pickers/pickadate/picker.time.js">
    </script>
    <script
        src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/forms/pickers/form-pickers.js">
    </script>
    <script
        src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/pages/app-calendar-events.js">
    </script>
    <script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/scripts/pages/app-calendar.js">
    </script>
    <script src="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/admin/app-assets/js/js.cookie.min.js">
    </script>
    <?php require $_SERVER['DOCUMENT_ROOT'].'/admin/system/settings/script.php'; ?>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    $("#randevuEkle").click(function() {
         if ($("#musteriAd").val()== ''){
            Swal.fire({
                title: "<?=$translations['error']?>",
                text: "<?=$translations['pleasename']?>",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "<?=$translations['okey']?>"
            });
           }else if ($("#musteriTelefon").val()== ''){
            Swal.fire({
                title: "<?=$translations['error']?>",
                text: "<?=$translations['pleasephone']?>",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "<?=$translations['okey']?>"
            });
         } else if ($('#service').val() == undefined) {
            Swal.fire({
                title: "<?=$translations['error']?>",
                text: "<?=$translations['pleaseservice']?>",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "<?=$translations['okey']?>"
            });
        } else if ($('#providerID').val() == '') {
            Swal.fire({
                title: "<?=$translations['error']?>",
                text: "<?=$translations['pleaseemp']?>",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "<?=$translations['okey']?>"
            });
        } else if ($('#start-date').val() == '') {
            Swal.fire({
                title: "<?=$translations['error']?>",
                text: "<?=$translations['pleaseappdate']?>",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "<?=$translations['okey']?>"
            });
        } else if ($(".custom-option-item-check:checked").val()== undefined) {
            Swal.fire({
                title: "<?=$translations['error']?>",
                text: "<?=$translations['pleaseapptime']?>",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "<?=$translations['okey']?>"
            });
        } else {
            var form = $('#wizard')[0];
            var data = new FormData(form);
            var odemeYontemi = $('#odemeYontemi').val();
            if(odemeYontemi == 'Kredi'){
                $.ajax({
                type: 'post',
                url: 'payment-create',
                data: data,
                enctype: 'multipart/form-data',
                processData: false,
                contentType: false,
                cache: false,
                success: function(data) {
                    if(data == 'varvar'){
                        Swal.fire({
                    title: "<?=$translations['sorry']?>",
                    text: "<?=$translations['otherselect']?>",
                    icon: 'error',
                    confirmButtonColor: '#7367f0',
                    confirmButtonText: "<?=$translations['okey']?>"
                }).then((result) => {
                    if (result.isConfirmed) {
                        //document.getElementById("randevuOlustur").reset();
                        location.reload();
                    }
                    if (result.isDismissed) {
                        //document.getElementById("randevuOlustur").reset();
                        location.reload();
                    }
                })
                    }else{
                      location.href = "payment/"+data;
                    }
                }
            });
            }else{
            $.ajax({
            type: 'post',
            url: 'eral',
            data: data,
            enctype: 'multipart/form-data',
            processData: false,
            contentType: false,
            cache: false,
            success: function(data) {
                if(data == 'varvar'){
                    Swal.fire({
                title: "<?=$translations['sorry']?>",
                text: "<?=$translations['otherselect']?>",
                icon: 'error',
                confirmButtonColor: '#7367f0',
                confirmButtonText: "<?=$translations['okey']?>"
            }).then((result) => {
                if (result.isConfirmed) {
                    //document.getElementById("randevuOlustur").reset();
                    location.reload();
                }
                if (result.isDismissed) {
                    //document.getElementById("randevuOlustur").reset();
                    location.reload();
                }
            })
                }else{
                    var odemeYontemi = $('#odemeYontemi').val();
                    if(odemeYontemi=='Havale'){
                    location.href = "hsuccess";
                    }else{
                    location.href = "success";  
                    }
                }
            }
        });
       }
           }
    });
    </script>
    <script>
    var input = document.querySelector("#musteriTelefon");
    window.intlTelInput(input, {
        initialCountry: 'tr',
        separateDialCode: true,
    });
    </script>
    <script>
    feather.replace()
    </script>
    <script>
    $('#lang').change(function(){
    var lang = $(this).val();
    Cookies.set('lang', lang);
    location.reload();
    });
    </script>
</body>
</html>